import os
from baselines.vdm.video_diffusion_pytorch import Unet3D_Trajectory
from models.wm import WM_models
from torch.optim.lr_scheduler import LambdaLR


def customized_lr_scheduler(optimizer, warmup_steps=5000): # 5000 from u-vit
    from torch.optim.lr_scheduler import LambdaLR
    def fn(step):
        if warmup_steps > 0:
            return min(step / warmup_steps, 1)
        else:
            return 1
    return LambdaLR(optimizer, fn)


def get_lr_scheduler(optimizer, name, **kwargs):
    if name == 'warmup':
        return customized_lr_scheduler(optimizer, **kwargs)
    elif name == 'cosine':
        from torch.optim.lr_scheduler import CosineAnnealingLR
        return CosineAnnealingLR(optimizer, **kwargs)
    else:
        raise NotImplementedError(name)
    
def get_models(args):
    if 'WM' in args.model:
        return WM_models[args.model](
                input_size=args.latent_size,
                num_frames=args.num_frames,
                learn_sigma=args.learn_sigma,
                extras=args.extras,
                attention_mode = args.attention_mode,
                args = args
            )
    elif 'LVDM' in args.model and args.pre_encode:
        return Unet3D_Trajectory(
                dim = args.lvdm_dim, # 288
                dim_mults = (1, 2, 4, 8),
                channels = 4,
                cond_dim = 768,
                args = args
            )
    elif 'VDM' in args.model and not args.pre_encode:
        return Unet3D_Trajectory(
                dim = 64,
                dim_mults = (1, 2, 4, 8),
                channels = 3,
                cond_dim = 768,
                args = args
            )
    else:
        raise '{} Model Not Supported!'.format(args.model)
    